package me.snowdrop.istio.mixer.adapter.memquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MemquotaListBuilder extends MemquotaListFluentImpl<MemquotaListBuilder> implements VisitableBuilder<MemquotaList,MemquotaListBuilder>{

    MemquotaListFluent<?> fluent;
    Boolean validationEnabled;

    public MemquotaListBuilder(){
            this(true);
    }
    public MemquotaListBuilder(Boolean validationEnabled){
            this(new MemquotaList(), validationEnabled);
    }
    public MemquotaListBuilder(MemquotaListFluent<?> fluent){
            this(fluent, true);
    }
    public MemquotaListBuilder(MemquotaListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MemquotaList(), validationEnabled);
    }
    public MemquotaListBuilder(MemquotaListFluent<?> fluent,MemquotaList instance){
            this(fluent, instance, true);
    }
    public MemquotaListBuilder(MemquotaListFluent<?> fluent,MemquotaList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public MemquotaListBuilder(MemquotaList instance){
            this(instance,true);
    }
    public MemquotaListBuilder(MemquotaList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public MemquotaList build(){
            MemquotaList buildable = new MemquotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MemquotaListBuilder that = (MemquotaListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
