package me.snowdrop.istio.mixer.adapter.memquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface MemquotaListFluent<A extends MemquotaListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Memquota item);
    public A setToItems(int index,Memquota item);
    public A addToItems(Memquota... items);
    public A addAllToItems(Collection<Memquota> items);
    public A removeFromItems(Memquota... items);
    public A removeAllFromItems(Collection<Memquota> items);
    public A removeMatchingFromItems(Predicate<MemquotaBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Memquota> getItems();
    public List<Memquota> buildItems();
    public Memquota buildItem(int index);
    public Memquota buildFirstItem();
    public Memquota buildLastItem();
    public Memquota buildMatchingItem(Predicate<MemquotaBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<MemquotaBuilder> predicate);
    public A withItems(List<Memquota> items);
    public A withItems(Memquota... items);
    public Boolean hasItems();
    public MemquotaListFluent.ItemsNested<A> addNewItem();
    public MemquotaListFluent.ItemsNested<A> addNewItemLike(Memquota item);
    public MemquotaListFluent.ItemsNested<A> setNewItemLike(int index,Memquota item);
    public MemquotaListFluent.ItemsNested<A> editItem(int index);
    public MemquotaListFluent.ItemsNested<A> editFirstItem();
    public MemquotaListFluent.ItemsNested<A> editLastItem();
    public MemquotaListFluent.ItemsNested<A> editMatchingItem(Predicate<MemquotaBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,MemquotaFluent<MemquotaListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
