
package me.snowdrop.istio.mixer.adapter.memquota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "minDeduplicationDuration",
    "quotas"
})
@IstioKind(name = "memquota", plural = "memquotas")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class MemquotaSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("minDeduplicationDuration")
    @JsonPropertyDescription("")
    private Integer minDeduplicationDuration;
    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    @JsonPropertyDescription("")
    private List<Quota> quotas = new ArrayList<Quota>();
    private final static long serialVersionUID = -7297499694987590783L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MemquotaSpec() {
    }

    /**
     * 
     * @param quotas
     * @param minDeduplicationDuration
     */
    public MemquotaSpec(Integer minDeduplicationDuration, List<Quota> quotas) {
        super();
        this.minDeduplicationDuration = minDeduplicationDuration;
        this.quotas = quotas;
    }

    /**
     * 
     * 
     */
    @JsonProperty("minDeduplicationDuration")
    public Integer getMinDeduplicationDuration() {
        return minDeduplicationDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("minDeduplicationDuration")
    public void setMinDeduplicationDuration(Integer minDeduplicationDuration) {
        this.minDeduplicationDuration = minDeduplicationDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    public List<Quota> getQuotas() {
        return quotas;
    }

    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    public void setQuotas(List<Quota> quotas) {
        this.quotas = quotas;
    }

}
