package me.snowdrop.istio.mixer.adapter.memquota;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface MemquotaSpecFluent<A extends MemquotaSpecFluent<A>> extends Fluent<A>{


    public Integer getMinDeduplicationDuration();
    public A withMinDeduplicationDuration(Integer minDeduplicationDuration);
    public Boolean hasMinDeduplicationDuration();
    public A addToQuotas(int index,Quota item);
    public A setToQuotas(int index,Quota item);
    public A addToQuotas(Quota... items);
    public A addAllToQuotas(Collection<Quota> items);
    public A removeFromQuotas(Quota... items);
    public A removeAllFromQuotas(Collection<Quota> items);
    public A removeMatchingFromQuotas(io.fabric8.kubernetes.api.builder.Predicate<QuotaBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildQuotas instead.
 * @return The buildable object.
 */
@Deprecated public List<Quota> getQuotas();
    public List<Quota> buildQuotas();
    public Quota buildQuota(int index);
    public Quota buildFirstQuota();
    public Quota buildLastQuota();
    public Quota buildMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<QuotaBuilder> predicate);
    public Boolean hasMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<QuotaBuilder> predicate);
    public A withQuotas(List<Quota> quotas);
    public A withQuotas(Quota... quotas);
    public Boolean hasQuotas();
    public MemquotaSpecFluent.QuotasNested<A> addNewQuota();
    public MemquotaSpecFluent.QuotasNested<A> addNewQuotaLike(Quota item);
    public MemquotaSpecFluent.QuotasNested<A> setNewQuotaLike(int index,Quota item);
    public MemquotaSpecFluent.QuotasNested<A> editQuota(int index);
    public MemquotaSpecFluent.QuotasNested<A> editFirstQuota();
    public MemquotaSpecFluent.QuotasNested<A> editLastQuota();
    public MemquotaSpecFluent.QuotasNested<A> editMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<QuotaBuilder> predicate);

    public interface QuotasNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,QuotaFluent<MemquotaSpecFluent.QuotasNested<N>>{

        
    public N and();    public N endQuota();
}


}
