
package me.snowdrop.istio.mixer.adapter.memquota;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "maxAmount",
    "name",
    "overrides",
    "validDuration"
})
@IstioKind(name = "quota", plural = "quotas")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Quota implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("maxAmount")
    @JsonPropertyDescription("")
    private Integer maxAmount;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     * 
     */
    @JsonProperty("overrides")
    @JsonPropertyDescription("")
    private List<Override> overrides = new ArrayList<Override>();
    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Integer validDuration;
    private final static long serialVersionUID = 7661791975451832182L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Quota() {
    }

    /**
     * 
     * @param name
     * @param validDuration
     * @param overrides
     * @param maxAmount
     */
    public Quota(Integer maxAmount, String name, List<Override> overrides, Integer validDuration) {
        super();
        this.maxAmount = maxAmount;
        this.name = name;
        this.overrides = overrides;
        this.validDuration = validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxAmount")
    public Integer getMaxAmount() {
        return maxAmount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxAmount")
    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("overrides")
    public List<Override> getOverrides() {
        return overrides;
    }

    /**
     * 
     * 
     */
    @JsonProperty("overrides")
    public void setOverrides(List<Override> overrides) {
        this.overrides = overrides;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public Integer getValidDuration() {
        return validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public void setValidDuration(Integer validDuration) {
        this.validDuration = validDuration;
    }

}
