
package me.snowdrop.istio.mixer.adapter.opa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "checkMethod",
    "failClose",
    "policy"
})
@IstioKind(name = "opa", plural = "opas")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class OpaSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("checkMethod")
    @JsonPropertyDescription("")
    private String checkMethod;
    /**
     * 
     * 
     */
    @JsonProperty("failClose")
    @JsonPropertyDescription("")
    private Boolean failClose;
    /**
     * 
     * 
     */
    @JsonProperty("policy")
    @JsonPropertyDescription("")
    private List<String> policy = new ArrayList<String>();
    private final static long serialVersionUID = -6043585563948670339L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OpaSpec() {
    }

    /**
     * 
     * @param failClose
     * @param checkMethod
     * @param policy
     */
    public OpaSpec(String checkMethod, Boolean failClose, List<String> policy) {
        super();
        this.checkMethod = checkMethod;
        this.failClose = failClose;
        this.policy = policy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("checkMethod")
    public String getCheckMethod() {
        return checkMethod;
    }

    /**
     * 
     * 
     */
    @JsonProperty("checkMethod")
    public void setCheckMethod(String checkMethod) {
        this.checkMethod = checkMethod;
    }

    /**
     * 
     * 
     */
    @JsonProperty("failClose")
    public Boolean getFailClose() {
        return failClose;
    }

    /**
     * 
     * 
     */
    @JsonProperty("failClose")
    public void setFailClose(Boolean failClose) {
        this.failClose = failClose;
    }

    /**
     * 
     * 
     */
    @JsonProperty("policy")
    public List<String> getPolicy() {
        return policy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("policy")
    public void setPolicy(List<String> policy) {
        this.policy = policy;
    }

}
