
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "definition"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class BucketsDefinition implements Serializable
{

    @JsonProperty("definition")
    @JsonUnwrapped
    private me.snowdrop.istio.mixer.adapter.prometheus.BucketsDefinition.Definition definition;
    private final static long serialVersionUID = 5282948236472353376L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BucketsDefinition() {
    }

    /**
     * 
     * @param definition
     */
    public BucketsDefinition(me.snowdrop.istio.mixer.adapter.prometheus.BucketsDefinition.Definition definition) {
        super();
        this.definition = definition;
    }

    @JsonProperty("definition")
    public me.snowdrop.istio.mixer.adapter.prometheus.BucketsDefinition.Definition getDefinition() {
        return definition;
    }

    @JsonProperty("definition")
    public void setDefinition(me.snowdrop.istio.mixer.adapter.prometheus.BucketsDefinition.Definition definition) {
        this.definition = definition;
    }

    public interface Definition extends Serializable
    {


    }

}
