
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "bounds"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Explicit implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("bounds")
    @JsonPropertyDescription("")
    private List<Double> bounds = new ArrayList<Double>();
    private final static long serialVersionUID = -2296895634052984787L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Explicit() {
    }

    /**
     * 
     * @param bounds
     */
    public Explicit(List<Double> bounds) {
        super();
        this.bounds = bounds;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bounds")
    public List<Double> getBounds() {
        return bounds;
    }

    /**
     * 
     * 
     */
    @JsonProperty("bounds")
    public void setBounds(List<Double> bounds) {
        this.bounds = bounds;
    }

}
