package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExplicitBucketsDefinitionBuilder extends ExplicitBucketsDefinitionFluentImpl<ExplicitBucketsDefinitionBuilder> implements VisitableBuilder<ExplicitBucketsDefinition,ExplicitBucketsDefinitionBuilder>{

    ExplicitBucketsDefinitionFluent<?> fluent;
    Boolean validationEnabled;

    public ExplicitBucketsDefinitionBuilder(){
            this(true);
    }
    public ExplicitBucketsDefinitionBuilder(Boolean validationEnabled){
            this(new ExplicitBucketsDefinition(), validationEnabled);
    }
    public ExplicitBucketsDefinitionBuilder(ExplicitBucketsDefinitionFluent<?> fluent){
            this(fluent, true);
    }
    public ExplicitBucketsDefinitionBuilder(ExplicitBucketsDefinitionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExplicitBucketsDefinition(), validationEnabled);
    }
    public ExplicitBucketsDefinitionBuilder(ExplicitBucketsDefinitionFluent<?> fluent,ExplicitBucketsDefinition instance){
            this(fluent, instance, true);
    }
    public ExplicitBucketsDefinitionBuilder(ExplicitBucketsDefinitionFluent<?> fluent,ExplicitBucketsDefinition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExplicitBuckets(instance.getExplicitBuckets()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExplicitBucketsDefinitionBuilder(ExplicitBucketsDefinition instance){
            this(instance,true);
    }
    public ExplicitBucketsDefinitionBuilder(ExplicitBucketsDefinition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExplicitBuckets(instance.getExplicitBuckets()); 
            this.validationEnabled = validationEnabled; 
    }

    public ExplicitBucketsDefinition build(){
            ExplicitBucketsDefinition buildable = new ExplicitBucketsDefinition(fluent.getExplicitBuckets());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExplicitBucketsDefinitionBuilder that = (ExplicitBucketsDefinitionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
