package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExplicitBuilder extends ExplicitFluentImpl<ExplicitBuilder> implements VisitableBuilder<Explicit,ExplicitBuilder>{

    ExplicitFluent<?> fluent;
    Boolean validationEnabled;

    public ExplicitBuilder(){
            this(true);
    }
    public ExplicitBuilder(Boolean validationEnabled){
            this(new Explicit(), validationEnabled);
    }
    public ExplicitBuilder(ExplicitFluent<?> fluent){
            this(fluent, true);
    }
    public ExplicitBuilder(ExplicitFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Explicit(), validationEnabled);
    }
    public ExplicitBuilder(ExplicitFluent<?> fluent,Explicit instance){
            this(fluent, instance, true);
    }
    public ExplicitBuilder(ExplicitFluent<?> fluent,Explicit instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBounds(instance.getBounds()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExplicitBuilder(Explicit instance){
            this(instance,true);
    }
    public ExplicitBuilder(Explicit instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBounds(instance.getBounds()); 
            this.validationEnabled = validationEnabled; 
    }

    public Explicit build(){
            Explicit buildable = new Explicit(fluent.getBounds());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExplicitBuilder that = (ExplicitBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
