package me.snowdrop.istio.mixer.adapter.prometheus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.Double;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ExplicitFluentImpl<A extends ExplicitFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExplicitFluent<A>{

    private List<Double> bounds;

    public ExplicitFluentImpl(){
    }
    public ExplicitFluentImpl(Explicit instance){
            this.withBounds(instance.getBounds()); 
    }

    public A addToBounds(int index,Double item){
            if (this.bounds == null) {this.bounds = new ArrayList<Double>();}
            this.bounds.add(index, item);
            return (A)this;
    }

    public A setToBounds(int index,Double item){
            if (this.bounds == null) {this.bounds = new ArrayList<Double>();}
            this.bounds.set(index, item); return (A)this;
    }

    public A addToBounds(Double... items){
            if (this.bounds == null) {this.bounds = new ArrayList<Double>();}
            for (Double item : items) {this.bounds.add(item);} return (A)this;
    }

    public A addAllToBounds(Collection<Double> items){
            if (this.bounds == null) {this.bounds = new ArrayList<Double>();}
            for (Double item : items) {this.bounds.add(item);} return (A)this;
    }

    public A removeFromBounds(Double... items){
            for (Double item : items) {if (this.bounds!= null){ this.bounds.remove(item);}} return (A)this;
    }

    public A removeAllFromBounds(Collection<Double> items){
            for (Double item : items) {if (this.bounds!= null){ this.bounds.remove(item);}} return (A)this;
    }

    public List<Double> getBounds(){
            return this.bounds;
    }

    public Double getBound(int index){
            return this.bounds.get(index);
    }

    public Double getFirstBound(){
            return this.bounds.get(0);
    }

    public Double getLastBound(){
            return this.bounds.get(bounds.size() - 1);
    }

    public Double getMatchingBound(io.fabric8.kubernetes.api.builder.Predicate<Double> predicate){
            for (Double item: bounds) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingBound(io.fabric8.kubernetes.api.builder.Predicate<Double> predicate){
            for (Double item: bounds) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withBounds(List<Double> bounds){
            if (this.bounds != null) { _visitables.get("bounds").removeAll(this.bounds);}
            if (bounds != null) {this.bounds = new ArrayList<Double>(); for (Double item : bounds){this.addToBounds(item);}} else { this.bounds = null;} return (A) this;
    }

    public A withBounds(Double... bounds){
            if (this.bounds != null) {this.bounds.clear();}
            if (bounds != null) {for (Double item :bounds){ this.addToBounds(item);}} return (A) this;
    }

    public Boolean hasBounds(){
            return bounds != null && !bounds.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExplicitFluentImpl that = (ExplicitFluentImpl) o;
            if (bounds != null ? !bounds.equals(that.bounds) :that.bounds != null) return false;
            return true;
    }




}
