
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "growthFactor",
    "numFiniteBuckets",
    "scale"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Exponential implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("growthFactor")
    @JsonPropertyDescription("")
    private Double growthFactor;
    /**
     * 
     * 
     */
    @JsonProperty("numFiniteBuckets")
    @JsonPropertyDescription("")
    private Integer numFiniteBuckets;
    /**
     * 
     * 
     */
    @JsonProperty("scale")
    @JsonPropertyDescription("")
    private Double scale;
    private final static long serialVersionUID = 5739560187166983672L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Exponential() {
    }

    /**
     * 
     * @param growthFactor
     * @param scale
     * @param numFiniteBuckets
     */
    public Exponential(Double growthFactor, Integer numFiniteBuckets, Double scale) {
        super();
        this.growthFactor = growthFactor;
        this.numFiniteBuckets = numFiniteBuckets;
        this.scale = scale;
    }

    /**
     * 
     * 
     */
    @JsonProperty("growthFactor")
    public Double getGrowthFactor() {
        return growthFactor;
    }

    /**
     * 
     * 
     */
    @JsonProperty("growthFactor")
    public void setGrowthFactor(Double growthFactor) {
        this.growthFactor = growthFactor;
    }

    /**
     * 
     * 
     */
    @JsonProperty("numFiniteBuckets")
    public Integer getNumFiniteBuckets() {
        return numFiniteBuckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("numFiniteBuckets")
    public void setNumFiniteBuckets(Integer numFiniteBuckets) {
        this.numFiniteBuckets = numFiniteBuckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("scale")
    public Double getScale() {
        return scale;
    }

    /**
     * 
     * 
     */
    @JsonProperty("scale")
    public void setScale(Double scale) {
        this.scale = scale;
    }

}
