package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExponentialBuilder extends ExponentialFluentImpl<ExponentialBuilder> implements VisitableBuilder<Exponential,ExponentialBuilder>{

    ExponentialFluent<?> fluent;
    Boolean validationEnabled;

    public ExponentialBuilder(){
            this(true);
    }
    public ExponentialBuilder(Boolean validationEnabled){
            this(new Exponential(), validationEnabled);
    }
    public ExponentialBuilder(ExponentialFluent<?> fluent){
            this(fluent, true);
    }
    public ExponentialBuilder(ExponentialFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Exponential(), validationEnabled);
    }
    public ExponentialBuilder(ExponentialFluent<?> fluent,Exponential instance){
            this(fluent, instance, true);
    }
    public ExponentialBuilder(ExponentialFluent<?> fluent,Exponential instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGrowthFactor(instance.getGrowthFactor()); 
            fluent.withNumFiniteBuckets(instance.getNumFiniteBuckets()); 
            fluent.withScale(instance.getScale()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExponentialBuilder(Exponential instance){
            this(instance,true);
    }
    public ExponentialBuilder(Exponential instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGrowthFactor(instance.getGrowthFactor()); 
            this.withNumFiniteBuckets(instance.getNumFiniteBuckets()); 
            this.withScale(instance.getScale()); 
            this.validationEnabled = validationEnabled; 
    }

    public Exponential build(){
            Exponential buildable = new Exponential(fluent.getGrowthFactor(),fluent.getNumFiniteBuckets(),fluent.getScale());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExponentialBuilder that = (ExponentialBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
