
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.mixer.adapter.prometheus.BucketsDefinition.Definition;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "linearBuckets"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class LinearBucketsDefinition implements Serializable, Definition
{

    /**
     * 
     * 
     */
    @JsonProperty("linearBuckets")
    @JsonPropertyDescription("")
    private Linear linearBuckets;
    private final static long serialVersionUID = 7279799471802604769L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LinearBucketsDefinition() {
    }

    /**
     * 
     * @param linearBuckets
     */
    public LinearBucketsDefinition(Linear linearBuckets) {
        super();
        this.linearBuckets = linearBuckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("linearBuckets")
    public Linear getLinearBuckets() {
        return linearBuckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("linearBuckets")
    public void setLinearBuckets(Linear linearBuckets) {
        this.linearBuckets = linearBuckets;
    }

}
