package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LinearBucketsDefinitionBuilder extends LinearBucketsDefinitionFluentImpl<LinearBucketsDefinitionBuilder> implements VisitableBuilder<LinearBucketsDefinition,LinearBucketsDefinitionBuilder>{

    LinearBucketsDefinitionFluent<?> fluent;
    Boolean validationEnabled;

    public LinearBucketsDefinitionBuilder(){
            this(true);
    }
    public LinearBucketsDefinitionBuilder(Boolean validationEnabled){
            this(new LinearBucketsDefinition(), validationEnabled);
    }
    public LinearBucketsDefinitionBuilder(LinearBucketsDefinitionFluent<?> fluent){
            this(fluent, true);
    }
    public LinearBucketsDefinitionBuilder(LinearBucketsDefinitionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LinearBucketsDefinition(), validationEnabled);
    }
    public LinearBucketsDefinitionBuilder(LinearBucketsDefinitionFluent<?> fluent,LinearBucketsDefinition instance){
            this(fluent, instance, true);
    }
    public LinearBucketsDefinitionBuilder(LinearBucketsDefinitionFluent<?> fluent,LinearBucketsDefinition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLinearBuckets(instance.getLinearBuckets()); 
            this.validationEnabled = validationEnabled; 
    }
    public LinearBucketsDefinitionBuilder(LinearBucketsDefinition instance){
            this(instance,true);
    }
    public LinearBucketsDefinitionBuilder(LinearBucketsDefinition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLinearBuckets(instance.getLinearBuckets()); 
            this.validationEnabled = validationEnabled; 
    }

    public LinearBucketsDefinition build(){
            LinearBucketsDefinition buildable = new LinearBucketsDefinition(fluent.getLinearBuckets());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LinearBucketsDefinitionBuilder that = (LinearBucketsDefinitionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
