package me.snowdrop.istio.mixer.adapter.prometheus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class MetricInfoFluentImpl<A extends me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluent<A>{

    private BucketsDefinitionBuilder buckets;
    private String description;
    private String instanceName;
    private Kind kind;
    private List<String> labelNames;
    private String name;
    private String namespace;

    public MetricInfoFluentImpl(){
    }
    public MetricInfoFluentImpl(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo instance){
            this.withBuckets(instance.getBuckets()); 
            this.withDescription(instance.getDescription()); 
            this.withInstanceName(instance.getInstanceName()); 
            this.withKind(instance.getKind()); 
            this.withLabelNames(instance.getLabelNames()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
    }

    
/**
 * This method has been deprecated, please use method buildBuckets instead.
 * @return The buildable object.
 */
@Deprecated public BucketsDefinition getBuckets(){
            return this.buckets!=null?this.buckets.build():null;
    }

    public BucketsDefinition buildBuckets(){
            return this.buckets!=null?this.buckets.build():null;
    }

    public A withBuckets(BucketsDefinition buckets){
            _visitables.get("buckets").remove(this.buckets);
            if (buckets!=null){ this.buckets= new BucketsDefinitionBuilder(buckets); _visitables.get("buckets").add(this.buckets);} return (A) this;
    }

    public Boolean hasBuckets(){
            return this.buckets != null;
    }

    public MetricInfoFluent.BucketsNested<A> withNewBuckets(){
            return new BucketsNestedImpl();
    }

    public MetricInfoFluent.BucketsNested<A> withNewBucketsLike(BucketsDefinition item){
            return new BucketsNestedImpl(item);
    }

    public MetricInfoFluent.BucketsNested<A> editBuckets(){
            return withNewBucketsLike(getBuckets());
    }

    public MetricInfoFluent.BucketsNested<A> editOrNewBuckets(){
            return withNewBucketsLike(getBuckets() != null ? getBuckets(): new BucketsDefinitionBuilder().build());
    }

    public MetricInfoFluent.BucketsNested<A> editOrNewBucketsLike(BucketsDefinition item){
            return withNewBucketsLike(getBuckets() != null ? getBuckets(): item);
    }

    public String getDescription(){
            return this.description;
    }

    public A withDescription(String description){
            this.description=description; return (A) this;
    }

    public Boolean hasDescription(){
            return this.description != null;
    }

    public A withNewDescription(String arg1){
            return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1){
            return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1){
            return (A)withDescription(new String(arg1));
    }

    public String getInstanceName(){
            return this.instanceName;
    }

    public A withInstanceName(String instanceName){
            this.instanceName=instanceName; return (A) this;
    }

    public Boolean hasInstanceName(){
            return this.instanceName != null;
    }

    public A withNewInstanceName(String arg1){
            return (A)withInstanceName(new String(arg1));
    }

    public A withNewInstanceName(StringBuilder arg1){
            return (A)withInstanceName(new String(arg1));
    }

    public A withNewInstanceName(StringBuffer arg1){
            return (A)withInstanceName(new String(arg1));
    }

    public Kind getKind(){
            return this.kind;
    }

    public A withKind(Kind kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A addToLabelNames(int index,String item){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            this.labelNames.add(index, item);
            return (A)this;
    }

    public A setToLabelNames(int index,String item){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            this.labelNames.set(index, item); return (A)this;
    }

    public A addToLabelNames(String... items){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            for (String item : items) {this.labelNames.add(item);} return (A)this;
    }

    public A addAllToLabelNames(Collection<String> items){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            for (String item : items) {this.labelNames.add(item);} return (A)this;
    }

    public A removeFromLabelNames(String... items){
            for (String item : items) {if (this.labelNames!= null){ this.labelNames.remove(item);}} return (A)this;
    }

    public A removeAllFromLabelNames(Collection<String> items){
            for (String item : items) {if (this.labelNames!= null){ this.labelNames.remove(item);}} return (A)this;
    }

    public List<String> getLabelNames(){
            return this.labelNames;
    }

    public String getLabelName(int index){
            return this.labelNames.get(index);
    }

    public String getFirstLabelName(){
            return this.labelNames.get(0);
    }

    public String getLastLabelName(){
            return this.labelNames.get(labelNames.size() - 1);
    }

    public String getMatchingLabelName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: labelNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingLabelName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: labelNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withLabelNames(List<String> labelNames){
            if (this.labelNames != null) { _visitables.get("labelNames").removeAll(this.labelNames);}
            if (labelNames != null) {this.labelNames = new ArrayList<String>(); for (String item : labelNames){this.addToLabelNames(item);}} else { this.labelNames = null;} return (A) this;
    }

    public A withLabelNames(String... labelNames){
            if (this.labelNames != null) {this.labelNames.clear();}
            if (labelNames != null) {for (String item :labelNames){ this.addToLabelNames(item);}} return (A) this;
    }

    public Boolean hasLabelNames(){
            return labelNames != null && !labelNames.isEmpty();
    }

    public A addNewLabelName(String arg1){
            return (A)addToLabelNames(new String(arg1));
    }

    public A addNewLabelName(StringBuilder arg1){
            return (A)addToLabelNames(new String(arg1));
    }

    public A addNewLabelName(StringBuffer arg1){
            return (A)addToLabelNames(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace(){
            return this.namespace != null;
    }

    public A withNewNamespace(String arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1){
            return (A)withNamespace(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            MetricInfoFluentImpl that = (MetricInfoFluentImpl) o;
            if (buckets != null ? !buckets.equals(that.buckets) :that.buckets != null) return false;
            if (description != null ? !description.equals(that.description) :that.description != null) return false;
            if (instanceName != null ? !instanceName.equals(that.instanceName) :that.instanceName != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (labelNames != null ? !labelNames.equals(that.labelNames) :that.labelNames != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            return true;
    }


    public class BucketsNestedImpl<N> extends BucketsDefinitionFluentImpl<MetricInfoFluent.BucketsNested<N>> implements MetricInfoFluent.BucketsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BucketsDefinitionBuilder builder;
    
            BucketsNestedImpl(BucketsDefinition item){
                    this.builder = new BucketsDefinitionBuilder(this, item);
            }
            BucketsNestedImpl(){
                    this.builder = new BucketsDefinitionBuilder(this);
            }
    
    public N and(){
            return (N) MetricInfoFluentImpl.this.withBuckets(builder.build());
    }
    public N endBuckets(){
            return and();
    }

}


}
