package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface PrometheusFluent<A extends PrometheusFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PrometheusFluent.MetadataNested<A> withNewMetadata();
    public PrometheusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PrometheusFluent.MetadataNested<A> editMetadata();
    public PrometheusFluent.MetadataNested<A> editOrNewMetadata();
    public PrometheusFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PrometheusSpec getSpec();
    public PrometheusSpec buildSpec();
    public A withSpec(PrometheusSpec spec);
    public Boolean hasSpec();
    public PrometheusFluent.SpecNested<A> withNewSpec();
    public PrometheusFluent.SpecNested<A> withNewSpecLike(PrometheusSpec item);
    public PrometheusFluent.SpecNested<A> editSpec();
    public PrometheusFluent.SpecNested<A> editOrNewSpec();
    public PrometheusFluent.SpecNested<A> editOrNewSpecLike(PrometheusSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PrometheusFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,PrometheusSpecFluent<PrometheusFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
