package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PrometheusSpecBuilder extends PrometheusSpecFluentImpl<PrometheusSpecBuilder> implements VisitableBuilder<PrometheusSpec,PrometheusSpecBuilder>{

    PrometheusSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PrometheusSpecBuilder(){
            this(true);
    }
    public PrometheusSpecBuilder(Boolean validationEnabled){
            this(new PrometheusSpec(), validationEnabled);
    }
    public PrometheusSpecBuilder(PrometheusSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PrometheusSpecBuilder(PrometheusSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PrometheusSpec(), validationEnabled);
    }
    public PrometheusSpecBuilder(PrometheusSpecFluent<?> fluent,PrometheusSpec instance){
            this(fluent, instance, true);
    }
    public PrometheusSpecBuilder(PrometheusSpecFluent<?> fluent,PrometheusSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withMetricsExpirationPolicy(instance.getMetricsExpirationPolicy()); 
            this.validationEnabled = validationEnabled; 
    }
    public PrometheusSpecBuilder(PrometheusSpec instance){
            this(instance,true);
    }
    public PrometheusSpecBuilder(PrometheusSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetrics(instance.getMetrics()); 
            this.withMetricsExpirationPolicy(instance.getMetricsExpirationPolicy()); 
            this.validationEnabled = validationEnabled; 
    }

    public PrometheusSpec build(){
            PrometheusSpec buildable = new PrometheusSpec(fluent.getMetrics(),fluent.getMetricsExpirationPolicy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PrometheusSpecBuilder that = (PrometheusSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
