package me.snowdrop.istio.mixer.adapter.prometheus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class PrometheusSpecFluentImpl<A extends PrometheusSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PrometheusSpecFluent<A>{

    private List<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder> metrics;
    private MetricsExpirationPolicyBuilder metricsExpirationPolicy;

    public PrometheusSpecFluentImpl(){
    }
    public PrometheusSpecFluentImpl(PrometheusSpec instance){
            this.withMetrics(instance.getMetrics()); 
            this.withMetricsExpirationPolicy(instance.getMetricsExpirationPolicy()); 
    }

    public A addToMetrics(int index,me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item){
            if (this.metrics == null) {this.metrics = new ArrayList<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder>();}
            me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder builder = new me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder(item);_visitables.get("metrics").add(index >= 0 ? index : _visitables.get("metrics").size(), builder);this.metrics.add(index >= 0 ? index : metrics.size(), builder); return (A)this;
    }

    public A setToMetrics(int index,me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item){
            if (this.metrics == null) {this.metrics = new ArrayList<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder>();}
            me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder builder = new me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder(item);
            if (index < 0 || index >= _visitables.get("metrics").size()) { _visitables.get("metrics").add(builder); } else { _visitables.get("metrics").set(index, builder);}
            if (index < 0 || index >= metrics.size()) { metrics.add(builder); } else { metrics.set(index, builder);}
             return (A)this;
    }

    public A addToMetrics(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo... items){
            if (this.metrics == null) {this.metrics = new ArrayList<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder>();}
            for (me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item : items) {me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder builder = new me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A addAllToMetrics(Collection<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo> items){
            if (this.metrics == null) {this.metrics = new ArrayList<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder>();}
            for (me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item : items) {me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder builder = new me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A removeFromMetrics(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo... items){
            for (me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item : items) {me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder builder = new me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    public A removeAllFromMetrics(Collection<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo> items){
            for (me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item : items) {me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder builder = new me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMetrics(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder> predicate){
            if (metrics == null) return (A) this;
            final Iterator<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder> each = metrics.iterator();
            final List visitables = _visitables.get("metrics");
            while (each.hasNext()) {
              me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo> getMetrics(){
            return build(metrics);
    }

    public List<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo> buildMetrics(){
            return build(metrics);
    }

    public me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo buildMetric(int index){
            return this.metrics.get(index).build();
    }

    public me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo buildFirstMetric(){
            return this.metrics.get(0).build();
    }

    public me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo buildLastMetric(){
            return this.metrics.get(metrics.size() - 1).build();
    }

    public me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo buildMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder> predicate){
            for (me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder item: metrics) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder> predicate){
            for (me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder item: metrics) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMetrics(List<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo> metrics){
            if (this.metrics != null) { _visitables.get("metrics").removeAll(this.metrics);}
            if (metrics != null) {this.metrics = new ArrayList<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder>(); for (me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item : metrics){this.addToMetrics(item);}} else { this.metrics = null;} return (A) this;
    }

    public A withMetrics(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo... metrics){
            if (this.metrics != null) {this.metrics.clear();}
            if (metrics != null) {for (me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item :metrics){ this.addToMetrics(item);}} return (A) this;
    }

    public Boolean hasMetrics(){
            return metrics != null && !metrics.isEmpty();
    }

    public PrometheusSpecFluent.MetricsNested<A> addNewMetric(){
            return new MetricsNestedImpl();
    }

    public PrometheusSpecFluent.MetricsNested<A> addNewMetricLike(me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item){
            return new MetricsNestedImpl(-1, item);
    }

    public PrometheusSpecFluent.MetricsNested<A> setNewMetricLike(int index,me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item){
            return new MetricsNestedImpl(index, item);
    }

    public PrometheusSpecFluent.MetricsNested<A> editMetric(int index){
            if (metrics.size() <= index) throw new RuntimeException("Can't edit metrics. Index exceeds size.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public PrometheusSpecFluent.MetricsNested<A> editFirstMetric(){
            if (metrics.size() == 0) throw new RuntimeException("Can't edit first metrics. The list is empty.");
            return setNewMetricLike(0, buildMetric(0));
    }

    public PrometheusSpecFluent.MetricsNested<A> editLastMetric(){
            int index = metrics.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last metrics. The list is empty.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public PrometheusSpecFluent.MetricsNested<A> editMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder> predicate){
            int index = -1;
            for (int i=0;i<metrics.size();i++) { 
            if (predicate.apply(metrics.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching metrics. No match found.");
            return setNewMetricLike(index, buildMetric(index));
    }

    
/**
 * This method has been deprecated, please use method buildMetricsExpirationPolicy instead.
 * @return The buildable object.
 */
@Deprecated public MetricsExpirationPolicy getMetricsExpirationPolicy(){
            return this.metricsExpirationPolicy!=null?this.metricsExpirationPolicy.build():null;
    }

    public MetricsExpirationPolicy buildMetricsExpirationPolicy(){
            return this.metricsExpirationPolicy!=null?this.metricsExpirationPolicy.build():null;
    }

    public A withMetricsExpirationPolicy(MetricsExpirationPolicy metricsExpirationPolicy){
            _visitables.get("metricsExpirationPolicy").remove(this.metricsExpirationPolicy);
            if (metricsExpirationPolicy!=null){ this.metricsExpirationPolicy= new MetricsExpirationPolicyBuilder(metricsExpirationPolicy); _visitables.get("metricsExpirationPolicy").add(this.metricsExpirationPolicy);} return (A) this;
    }

    public Boolean hasMetricsExpirationPolicy(){
            return this.metricsExpirationPolicy != null;
    }

    public A withNewMetricsExpirationPolicy(Integer expiryCheckIntervalDuration,Integer metricsExpiryDuration){
            return (A)withMetricsExpirationPolicy(new MetricsExpirationPolicy(expiryCheckIntervalDuration, metricsExpiryDuration));
    }

    public PrometheusSpecFluent.MetricsExpirationPolicyNested<A> withNewMetricsExpirationPolicy(){
            return new MetricsExpirationPolicyNestedImpl();
    }

    public PrometheusSpecFluent.MetricsExpirationPolicyNested<A> withNewMetricsExpirationPolicyLike(MetricsExpirationPolicy item){
            return new MetricsExpirationPolicyNestedImpl(item);
    }

    public PrometheusSpecFluent.MetricsExpirationPolicyNested<A> editMetricsExpirationPolicy(){
            return withNewMetricsExpirationPolicyLike(getMetricsExpirationPolicy());
    }

    public PrometheusSpecFluent.MetricsExpirationPolicyNested<A> editOrNewMetricsExpirationPolicy(){
            return withNewMetricsExpirationPolicyLike(getMetricsExpirationPolicy() != null ? getMetricsExpirationPolicy(): new MetricsExpirationPolicyBuilder().build());
    }

    public PrometheusSpecFluent.MetricsExpirationPolicyNested<A> editOrNewMetricsExpirationPolicyLike(MetricsExpirationPolicy item){
            return withNewMetricsExpirationPolicyLike(getMetricsExpirationPolicy() != null ? getMetricsExpirationPolicy(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PrometheusSpecFluentImpl that = (PrometheusSpecFluentImpl) o;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (metricsExpirationPolicy != null ? !metricsExpirationPolicy.equals(that.metricsExpirationPolicy) :that.metricsExpirationPolicy != null) return false;
            return true;
    }


    public class MetricsNestedImpl<N> extends me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoFluentImpl<PrometheusSpecFluent.MetricsNested<N>> implements PrometheusSpecFluent.MetricsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder builder;
        private final int index;
    
            MetricsNestedImpl(int index,me.snowdrop.istio.mixer.adapter.prometheus.MetricInfo item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder(this, item);
            }
            MetricsNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.mixer.adapter.prometheus.MetricInfoBuilder(this);
            }
    
    public N and(){
            return (N) PrometheusSpecFluentImpl.this.setToMetrics(index, builder.build());
    }
    public N endMetric(){
            return and();
    }

}
    public class MetricsExpirationPolicyNestedImpl<N> extends MetricsExpirationPolicyFluentImpl<PrometheusSpecFluent.MetricsExpirationPolicyNested<N>> implements PrometheusSpecFluent.MetricsExpirationPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final MetricsExpirationPolicyBuilder builder;
    
            MetricsExpirationPolicyNestedImpl(MetricsExpirationPolicy item){
                    this.builder = new MetricsExpirationPolicyBuilder(this, item);
            }
            MetricsExpirationPolicyNestedImpl(){
                    this.builder = new MetricsExpirationPolicyBuilder(this);
            }
    
    public N and(){
            return (N) PrometheusSpecFluentImpl.this.withMetricsExpirationPolicy(builder.build());
    }
    public N endMetricsExpirationPolicy(){
            return and();
    }

}


}
