package me.snowdrop.istio.mixer.adapter.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RbacBuilder extends RbacFluentImpl<RbacBuilder> implements VisitableBuilder<Rbac,RbacBuilder>{

    RbacFluent<?> fluent;
    Boolean validationEnabled;

    public RbacBuilder(){
            this(true);
    }
    public RbacBuilder(Boolean validationEnabled){
            this(new Rbac(), validationEnabled);
    }
    public RbacBuilder(RbacFluent<?> fluent){
            this(fluent, true);
    }
    public RbacBuilder(RbacFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Rbac(), validationEnabled);
    }
    public RbacBuilder(RbacFluent<?> fluent,Rbac instance){
            this(fluent, instance, true);
    }
    public RbacBuilder(RbacFluent<?> fluent,Rbac instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacBuilder(Rbac instance){
            this(instance,true);
    }
    public RbacBuilder(Rbac instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Rbac build(){
            Rbac buildable = new Rbac(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RbacBuilder that = (RbacBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
