package me.snowdrop.istio.mixer.adapter.rbac;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface RbacFluent<A extends RbacFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public RbacFluent.MetadataNested<A> withNewMetadata();
    public RbacFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RbacFluent.MetadataNested<A> editMetadata();
    public RbacFluent.MetadataNested<A> editOrNewMetadata();
    public RbacFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public RbacSpec getSpec();
    public RbacSpec buildSpec();
    public A withSpec(RbacSpec spec);
    public Boolean hasSpec();
    public A withNewSpec(Integer cacheDuration,String configStoreUrl);
    public RbacFluent.SpecNested<A> withNewSpec();
    public RbacFluent.SpecNested<A> withNewSpecLike(RbacSpec item);
    public RbacFluent.SpecNested<A> editSpec();
    public RbacFluent.SpecNested<A> editOrNewSpec();
    public RbacFluent.SpecNested<A> editOrNewSpecLike(RbacSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<RbacFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,RbacSpecFluent<RbacFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
