package me.snowdrop.istio.mixer.adapter.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface RbacListFluent<A extends RbacListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Rbac item);
    public A setToItems(int index,Rbac item);
    public A addToItems(Rbac... items);
    public A addAllToItems(Collection<Rbac> items);
    public A removeFromItems(Rbac... items);
    public A removeAllFromItems(Collection<Rbac> items);
    public A removeMatchingFromItems(Predicate<RbacBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Rbac> getItems();
    public List<Rbac> buildItems();
    public Rbac buildItem(int index);
    public Rbac buildFirstItem();
    public Rbac buildLastItem();
    public Rbac buildMatchingItem(Predicate<RbacBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<RbacBuilder> predicate);
    public A withItems(List<Rbac> items);
    public A withItems(Rbac... items);
    public Boolean hasItems();
    public RbacListFluent.ItemsNested<A> addNewItem();
    public RbacListFluent.ItemsNested<A> addNewItemLike(Rbac item);
    public RbacListFluent.ItemsNested<A> setNewItemLike(int index,Rbac item);
    public RbacListFluent.ItemsNested<A> editItem(int index);
    public RbacListFluent.ItemsNested<A> editFirstItem();
    public RbacListFluent.ItemsNested<A> editLastItem();
    public RbacListFluent.ItemsNested<A> editMatchingItem(Predicate<RbacBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,RbacFluent<RbacListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
