
package me.snowdrop.istio.mixer.adapter.redisquota;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "dimensions",
    "maxAmount"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Override implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    @JsonPropertyDescription("")
    private Map<String, String> dimensions;
    /**
     * 
     * 
     */
    @JsonProperty("maxAmount")
    @JsonPropertyDescription("")
    private Integer maxAmount;
    private final static long serialVersionUID = -5815529210573572724L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Override() {
    }

    /**
     * 
     * @param maxAmount
     * @param dimensions
     */
    public Override(Map<String, String> dimensions, Integer maxAmount) {
        super();
        this.dimensions = dimensions;
        this.maxAmount = maxAmount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    public Map<String, String> getDimensions() {
        return dimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("dimensions")
    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxAmount")
    public Integer getMaxAmount() {
        return maxAmount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxAmount")
    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }

}
