package me.snowdrop.istio.mixer.adapter.redisquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class QuotaBuilder extends me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluentImpl<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder> implements VisitableBuilder<me.snowdrop.istio.mixer.adapter.redisquota.Quota,me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder>{

    me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluent<?> fluent;
    Boolean validationEnabled;

    public QuotaBuilder(){
            this(true);
    }
    public QuotaBuilder(Boolean validationEnabled){
            this(new Quota(), validationEnabled);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluent<?> fluent){
            this(fluent, true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Quota(), validationEnabled);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluent<?> fluent,me.snowdrop.istio.mixer.adapter.redisquota.Quota instance){
            this(fluent, instance, true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluent<?> fluent,me.snowdrop.istio.mixer.adapter.redisquota.Quota instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBucketDuration(instance.getBucketDuration()); 
            fluent.withMaxAmount(instance.getMaxAmount()); 
            fluent.withName(instance.getName()); 
            fluent.withOverrides(instance.getOverrides()); 
            fluent.withRateLimitAlgorithm(instance.getRateLimitAlgorithm()); 
            fluent.withValidDuration(instance.getValidDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.redisquota.Quota instance){
            this(instance,true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.redisquota.Quota instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBucketDuration(instance.getBucketDuration()); 
            this.withMaxAmount(instance.getMaxAmount()); 
            this.withName(instance.getName()); 
            this.withOverrides(instance.getOverrides()); 
            this.withRateLimitAlgorithm(instance.getRateLimitAlgorithm()); 
            this.withValidDuration(instance.getValidDuration()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Quota build(){
            Quota buildable = new Quota(fluent.getBucketDuration(),fluent.getMaxAmount(),fluent.getName(),fluent.getOverrides(),fluent.getRateLimitAlgorithm(),fluent.getValidDuration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaBuilder that = (QuotaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
