package me.snowdrop.istio.mixer.adapter.redisquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RedisquotaBuilder extends RedisquotaFluentImpl<RedisquotaBuilder> implements VisitableBuilder<Redisquota,RedisquotaBuilder>{

    RedisquotaFluent<?> fluent;
    Boolean validationEnabled;

    public RedisquotaBuilder(){
            this(true);
    }
    public RedisquotaBuilder(Boolean validationEnabled){
            this(new Redisquota(), validationEnabled);
    }
    public RedisquotaBuilder(RedisquotaFluent<?> fluent){
            this(fluent, true);
    }
    public RedisquotaBuilder(RedisquotaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Redisquota(), validationEnabled);
    }
    public RedisquotaBuilder(RedisquotaFluent<?> fluent,Redisquota instance){
            this(fluent, instance, true);
    }
    public RedisquotaBuilder(RedisquotaFluent<?> fluent,Redisquota instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public RedisquotaBuilder(Redisquota instance){
            this(instance,true);
    }
    public RedisquotaBuilder(Redisquota instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Redisquota build(){
            Redisquota buildable = new Redisquota(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RedisquotaBuilder that = (RedisquotaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
