package me.snowdrop.istio.mixer.adapter.redisquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RedisquotaListBuilder extends RedisquotaListFluentImpl<RedisquotaListBuilder> implements VisitableBuilder<RedisquotaList,RedisquotaListBuilder>{

    RedisquotaListFluent<?> fluent;
    Boolean validationEnabled;

    public RedisquotaListBuilder(){
            this(true);
    }
    public RedisquotaListBuilder(Boolean validationEnabled){
            this(new RedisquotaList(), validationEnabled);
    }
    public RedisquotaListBuilder(RedisquotaListFluent<?> fluent){
            this(fluent, true);
    }
    public RedisquotaListBuilder(RedisquotaListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RedisquotaList(), validationEnabled);
    }
    public RedisquotaListBuilder(RedisquotaListFluent<?> fluent,RedisquotaList instance){
            this(fluent, instance, true);
    }
    public RedisquotaListBuilder(RedisquotaListFluent<?> fluent,RedisquotaList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public RedisquotaListBuilder(RedisquotaList instance){
            this(instance,true);
    }
    public RedisquotaListBuilder(RedisquotaList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public RedisquotaList build(){
            RedisquotaList buildable = new RedisquotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RedisquotaListBuilder that = (RedisquotaListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
