package me.snowdrop.istio.mixer.adapter.signalfx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetricConfigBuilder extends MetricConfigFluentImpl<MetricConfigBuilder> implements VisitableBuilder<MetricConfig,MetricConfigBuilder>{

    MetricConfigFluent<?> fluent;
    Boolean validationEnabled;

    public MetricConfigBuilder(){
            this(true);
    }
    public MetricConfigBuilder(Boolean validationEnabled){
            this(new MetricConfig(), validationEnabled);
    }
    public MetricConfigBuilder(MetricConfigFluent<?> fluent){
            this(fluent, true);
    }
    public MetricConfigBuilder(MetricConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetricConfig(), validationEnabled);
    }
    public MetricConfigBuilder(MetricConfigFluent<?> fluent,MetricConfig instance){
            this(fluent, instance, true);
    }
    public MetricConfigBuilder(MetricConfigFluent<?> fluent,MetricConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricConfigBuilder(MetricConfig instance){
            this(instance,true);
    }
    public MetricConfigBuilder(MetricConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public MetricConfig build(){
            MetricConfig buildable = new MetricConfig(fluent.getName(),fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricConfigBuilder that = (MetricConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
