
package me.snowdrop.istio.mixer.adapter.signalfx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "accessToken",
    "datapointInterval",
    "enableMetrics",
    "enableTracing",
    "ingestUrl",
    "metrics",
    "tracingBufferSize",
    "tracingSampleProbability"
})
@IstioKind(name = "signalfx", plural = "signalfxs")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class SignalfxSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("accessToken")
    @JsonPropertyDescription("")
    private String accessToken;
    /**
     * 
     * 
     */
    @JsonProperty("datapointInterval")
    @JsonPropertyDescription("")
    private Integer datapointInterval;
    /**
     * 
     * 
     */
    @JsonProperty("enableMetrics")
    @JsonPropertyDescription("")
    private Boolean enableMetrics;
    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    @JsonPropertyDescription("")
    private Boolean enableTracing;
    /**
     * 
     * 
     */
    @JsonProperty("ingestUrl")
    @JsonPropertyDescription("")
    private String ingestUrl;
    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    private List<MetricConfig> metrics = new ArrayList<MetricConfig>();
    /**
     * 
     * 
     */
    @JsonProperty("tracingBufferSize")
    @JsonPropertyDescription("")
    private Integer tracingBufferSize;
    /**
     * 
     * 
     */
    @JsonProperty("tracingSampleProbability")
    @JsonPropertyDescription("")
    private Double tracingSampleProbability;
    private final static long serialVersionUID = -1531278674775946140L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SignalfxSpec() {
    }

    /**
     * 
     * @param enableMetrics
     * @param ingestUrl
     * @param tracingSampleProbability
     * @param enableTracing
     * @param metrics
     * @param accessToken
     * @param datapointInterval
     * @param tracingBufferSize
     */
    public SignalfxSpec(String accessToken, Integer datapointInterval, Boolean enableMetrics, Boolean enableTracing, String ingestUrl, List<MetricConfig> metrics, Integer tracingBufferSize, Double tracingSampleProbability) {
        super();
        this.accessToken = accessToken;
        this.datapointInterval = datapointInterval;
        this.enableMetrics = enableMetrics;
        this.enableTracing = enableTracing;
        this.ingestUrl = ingestUrl;
        this.metrics = metrics;
        this.tracingBufferSize = tracingBufferSize;
        this.tracingSampleProbability = tracingSampleProbability;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessToken")
    public String getAccessToken() {
        return accessToken;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessToken")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * 
     * 
     */
    @JsonProperty("datapointInterval")
    public Integer getDatapointInterval() {
        return datapointInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("datapointInterval")
    public void setDatapointInterval(Integer datapointInterval) {
        this.datapointInterval = datapointInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableMetrics")
    public Boolean getEnableMetrics() {
        return enableMetrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableMetrics")
    public void setEnableMetrics(Boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    public Boolean getEnableTracing() {
        return enableTracing;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    public void setEnableTracing(Boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingestUrl")
    public String getIngestUrl() {
        return ingestUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingestUrl")
    public void setIngestUrl(String ingestUrl) {
        this.ingestUrl = ingestUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public List<MetricConfig> getMetrics() {
        return metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public void setMetrics(List<MetricConfig> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tracingBufferSize")
    public Integer getTracingBufferSize() {
        return tracingBufferSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tracingBufferSize")
    public void setTracingBufferSize(Integer tracingBufferSize) {
        this.tracingBufferSize = tracingBufferSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tracingSampleProbability")
    public Double getTracingSampleProbability() {
        return tracingSampleProbability;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tracingSampleProbability")
    public void setTracingSampleProbability(Double tracingSampleProbability) {
        this.tracingSampleProbability = tracingSampleProbability;
    }

}
