package me.snowdrop.istio.mixer.adapter.signalfx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SignalfxSpecBuilder extends SignalfxSpecFluentImpl<SignalfxSpecBuilder> implements VisitableBuilder<SignalfxSpec,SignalfxSpecBuilder>{

    SignalfxSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SignalfxSpecBuilder(){
            this(true);
    }
    public SignalfxSpecBuilder(Boolean validationEnabled){
            this(new SignalfxSpec(), validationEnabled);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SignalfxSpec(), validationEnabled);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent,SignalfxSpec instance){
            this(fluent, instance, true);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent,SignalfxSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccessToken(instance.getAccessToken()); 
            fluent.withDatapointInterval(instance.getDatapointInterval()); 
            fluent.withEnableMetrics(instance.getEnableMetrics()); 
            fluent.withEnableTracing(instance.getEnableTracing()); 
            fluent.withIngestUrl(instance.getIngestUrl()); 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withTracingBufferSize(instance.getTracingBufferSize()); 
            fluent.withTracingSampleProbability(instance.getTracingSampleProbability()); 
            this.validationEnabled = validationEnabled; 
    }
    public SignalfxSpecBuilder(SignalfxSpec instance){
            this(instance,true);
    }
    public SignalfxSpecBuilder(SignalfxSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccessToken(instance.getAccessToken()); 
            this.withDatapointInterval(instance.getDatapointInterval()); 
            this.withEnableMetrics(instance.getEnableMetrics()); 
            this.withEnableTracing(instance.getEnableTracing()); 
            this.withIngestUrl(instance.getIngestUrl()); 
            this.withMetrics(instance.getMetrics()); 
            this.withTracingBufferSize(instance.getTracingBufferSize()); 
            this.withTracingSampleProbability(instance.getTracingSampleProbability()); 
            this.validationEnabled = validationEnabled; 
    }

    public SignalfxSpec build(){
            SignalfxSpec buildable = new SignalfxSpec(fluent.getAccessToken(),fluent.getDatapointInterval(),fluent.isEnableMetrics(),fluent.isEnableTracing(),fluent.getIngestUrl(),fluent.getMetrics(),fluent.getTracingBufferSize(),fluent.getTracingSampleProbability());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SignalfxSpecBuilder that = (SignalfxSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
