
package me.snowdrop.istio.mixer.adapter.solarwinds;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "payloadTemplate"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class LogInfo implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("payloadTemplate")
    @JsonPropertyDescription("")
    private String payloadTemplate;
    private final static long serialVersionUID = -3394220302549648486L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LogInfo() {
    }

    /**
     * 
     * @param payloadTemplate
     */
    public LogInfo(String payloadTemplate) {
        super();
        this.payloadTemplate = payloadTemplate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("payloadTemplate")
    public String getPayloadTemplate() {
        return payloadTemplate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("payloadTemplate")
    public void setPayloadTemplate(String payloadTemplate) {
        this.payloadTemplate = payloadTemplate;
    }

}
