package me.snowdrop.istio.mixer.adapter.solarwinds;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SolarwindsBuilder extends SolarwindsFluentImpl<SolarwindsBuilder> implements VisitableBuilder<Solarwinds,SolarwindsBuilder>{

    SolarwindsFluent<?> fluent;
    Boolean validationEnabled;

    public SolarwindsBuilder(){
            this(true);
    }
    public SolarwindsBuilder(Boolean validationEnabled){
            this(new Solarwinds(), validationEnabled);
    }
    public SolarwindsBuilder(SolarwindsFluent<?> fluent){
            this(fluent, true);
    }
    public SolarwindsBuilder(SolarwindsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Solarwinds(), validationEnabled);
    }
    public SolarwindsBuilder(SolarwindsFluent<?> fluent,Solarwinds instance){
            this(fluent, instance, true);
    }
    public SolarwindsBuilder(SolarwindsFluent<?> fluent,Solarwinds instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public SolarwindsBuilder(Solarwinds instance){
            this(instance,true);
    }
    public SolarwindsBuilder(Solarwinds instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Solarwinds build(){
            Solarwinds buildable = new Solarwinds(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SolarwindsBuilder that = (SolarwindsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
