package me.snowdrop.istio.mixer.adapter.solarwinds;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SolarwindsSpecBuilder extends SolarwindsSpecFluentImpl<SolarwindsSpecBuilder> implements VisitableBuilder<SolarwindsSpec,SolarwindsSpecBuilder>{

    SolarwindsSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SolarwindsSpecBuilder(){
            this(true);
    }
    public SolarwindsSpecBuilder(Boolean validationEnabled){
            this(new SolarwindsSpec(), validationEnabled);
    }
    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SolarwindsSpec(), validationEnabled);
    }
    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent,SolarwindsSpec instance){
            this(fluent, instance, true);
    }
    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent,SolarwindsSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAppopticsAccessToken(instance.getAppopticsAccessToken()); 
            fluent.withAppopticsBatchSize(instance.getAppopticsBatchSize()); 
            fluent.withLogs(instance.getLogs()); 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration()); 
            fluent.withPapertrailUrl(instance.getPapertrailUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public SolarwindsSpecBuilder(SolarwindsSpec instance){
            this(instance,true);
    }
    public SolarwindsSpecBuilder(SolarwindsSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAppopticsAccessToken(instance.getAppopticsAccessToken()); 
            this.withAppopticsBatchSize(instance.getAppopticsBatchSize()); 
            this.withLogs(instance.getLogs()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration()); 
            this.withPapertrailUrl(instance.getPapertrailUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public SolarwindsSpec build(){
            SolarwindsSpec buildable = new SolarwindsSpec(fluent.getAppopticsAccessToken(),fluent.getAppopticsBatchSize(),fluent.getLogs(),fluent.getMetrics(),fluent.getPapertrailLocalRetentionDuration(),fluent.getPapertrailUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SolarwindsSpecBuilder that = (SolarwindsSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
