package me.snowdrop.istio.mixer.adapter.solarwinds;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class SolarwindsSpecFluentImpl<A extends SolarwindsSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SolarwindsSpecFluent<A>{

    private String appopticsAccessToken;
    private Integer appopticsBatchSize;
    private Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> logs;
    private Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> metrics;
    private Integer papertrailLocalRetentionDuration;
    private String papertrailUrl;

    public SolarwindsSpecFluentImpl(){
    }
    public SolarwindsSpecFluentImpl(SolarwindsSpec instance){
            this.withAppopticsAccessToken(instance.getAppopticsAccessToken()); 
            this.withAppopticsBatchSize(instance.getAppopticsBatchSize()); 
            this.withLogs(instance.getLogs()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration()); 
            this.withPapertrailUrl(instance.getPapertrailUrl()); 
    }

    public String getAppopticsAccessToken(){
            return this.appopticsAccessToken;
    }

    public A withAppopticsAccessToken(String appopticsAccessToken){
            this.appopticsAccessToken=appopticsAccessToken; return (A) this;
    }

    public Boolean hasAppopticsAccessToken(){
            return this.appopticsAccessToken != null;
    }

    public A withNewAppopticsAccessToken(String arg1){
            return (A)withAppopticsAccessToken(new String(arg1));
    }

    public A withNewAppopticsAccessToken(StringBuilder arg1){
            return (A)withAppopticsAccessToken(new String(arg1));
    }

    public A withNewAppopticsAccessToken(StringBuffer arg1){
            return (A)withAppopticsAccessToken(new String(arg1));
    }

    public Integer getAppopticsBatchSize(){
            return this.appopticsBatchSize;
    }

    public A withAppopticsBatchSize(Integer appopticsBatchSize){
            this.appopticsBatchSize=appopticsBatchSize; return (A) this;
    }

    public Boolean hasAppopticsBatchSize(){
            return this.appopticsBatchSize != null;
    }

    public A addToLogs(String key,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo value){
            if(this.logs == null && key != null && value != null) { this.logs = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo>(); }
            if(key != null && value != null) {this.logs.put(key, value);} return (A)this;
    }

    public A addToLogs(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> map){
            if(this.logs == null && map != null) { this.logs = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo>(); }
            if(map != null) { this.logs.putAll(map);} return (A)this;
    }

    public A removeFromLogs(String key){
            if(this.logs == null) { return (A) this; }
            if(key != null && this.logs != null) {this.logs.remove(key);} return (A)this;
    }

    public A removeFromLogs(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> map){
            if(this.logs == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.logs != null){this.logs.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> getLogs(){
            return this.logs;
    }

    public A withLogs(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo> logs){
            if (logs == null) { this.logs =  null;} else {this.logs = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.solarwinds.LogInfo>(logs);} return (A) this;
    }

    public Boolean hasLogs(){
            return this.logs != null;
    }

    public A addToMetrics(String key,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo value){
            if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo>(); }
            if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> map){
            if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo>(); }
            if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key){
            if(this.metrics == null) { return (A) this; }
            if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> map){
            if(this.metrics == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> getMetrics(){
            return this.metrics;
    }

    public A withMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> metrics){
            if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo>(metrics);} return (A) this;
    }

    public Boolean hasMetrics(){
            return this.metrics != null;
    }

    public Integer getPapertrailLocalRetentionDuration(){
            return this.papertrailLocalRetentionDuration;
    }

    public A withPapertrailLocalRetentionDuration(Integer papertrailLocalRetentionDuration){
            this.papertrailLocalRetentionDuration=papertrailLocalRetentionDuration; return (A) this;
    }

    public Boolean hasPapertrailLocalRetentionDuration(){
            return this.papertrailLocalRetentionDuration != null;
    }

    public String getPapertrailUrl(){
            return this.papertrailUrl;
    }

    public A withPapertrailUrl(String papertrailUrl){
            this.papertrailUrl=papertrailUrl; return (A) this;
    }

    public Boolean hasPapertrailUrl(){
            return this.papertrailUrl != null;
    }

    public A withNewPapertrailUrl(String arg1){
            return (A)withPapertrailUrl(new String(arg1));
    }

    public A withNewPapertrailUrl(StringBuilder arg1){
            return (A)withPapertrailUrl(new String(arg1));
    }

    public A withNewPapertrailUrl(StringBuffer arg1){
            return (A)withPapertrailUrl(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SolarwindsSpecFluentImpl that = (SolarwindsSpecFluentImpl) o;
            if (appopticsAccessToken != null ? !appopticsAccessToken.equals(that.appopticsAccessToken) :that.appopticsAccessToken != null) return false;
            if (appopticsBatchSize != null ? !appopticsBatchSize.equals(that.appopticsBatchSize) :that.appopticsBatchSize != null) return false;
            if (logs != null ? !logs.equals(that.logs) :that.logs != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (papertrailLocalRetentionDuration != null ? !papertrailLocalRetentionDuration.equals(that.papertrailLocalRetentionDuration) :that.papertrailLocalRetentionDuration != null) return false;
            if (papertrailUrl != null ? !papertrailUrl.equals(that.papertrailUrl) :that.papertrailUrl != null) return false;
            return true;
    }




}
