
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverSpec.Creds;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "apiKey"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ApiKeyCreds implements Serializable, Creds
{

    /**
     * 
     * 
     */
    @JsonProperty("apiKey")
    @JsonPropertyDescription("")
    private String apiKey;
    private final static long serialVersionUID = 6267212014433582452L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ApiKeyCreds() {
    }

    /**
     * 
     * @param apiKey
     */
    public ApiKeyCreds(String apiKey) {
        super();
        this.apiKey = apiKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiKey")
    public String getApiKey() {
        return apiKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("apiKey")
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

}
