
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "httpMapping",
    "labelNames",
    "payloadTemplate",
    "sinkInfo"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class LogInfo implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("httpMapping")
    @JsonPropertyDescription("")
    private HttpRequestMapping httpMapping;
    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    @JsonPropertyDescription("")
    private List<String> labelNames = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("payloadTemplate")
    @JsonPropertyDescription("")
    private String payloadTemplate;
    /**
     * 
     * 
     */
    @JsonProperty("sinkInfo")
    @JsonPropertyDescription("")
    private SinkInfo sinkInfo;
    private final static long serialVersionUID = 3808625117073622185L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LogInfo() {
    }

    /**
     * 
     * @param sinkInfo
     * @param labelNames
     * @param httpMapping
     * @param payloadTemplate
     */
    public LogInfo(HttpRequestMapping httpMapping, List<String> labelNames, String payloadTemplate, SinkInfo sinkInfo) {
        super();
        this.httpMapping = httpMapping;
        this.labelNames = labelNames;
        this.payloadTemplate = payloadTemplate;
        this.sinkInfo = sinkInfo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpMapping")
    public HttpRequestMapping getHttpMapping() {
        return httpMapping;
    }

    /**
     * 
     * 
     */
    @JsonProperty("httpMapping")
    public void setHttpMapping(HttpRequestMapping httpMapping) {
        this.httpMapping = httpMapping;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    public List<String> getLabelNames() {
        return labelNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    public void setLabelNames(List<String> labelNames) {
        this.labelNames = labelNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("payloadTemplate")
    public String getPayloadTemplate() {
        return payloadTemplate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("payloadTemplate")
    public void setPayloadTemplate(String payloadTemplate) {
        this.payloadTemplate = payloadTemplate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sinkInfo")
    public SinkInfo getSinkInfo() {
        return sinkInfo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sinkInfo")
    public void setSinkInfo(SinkInfo sinkInfo) {
        this.sinkInfo = sinkInfo;
    }

}
