package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LogInfoBuilder extends me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoFluentImpl<me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoBuilder> implements VisitableBuilder<me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoBuilder>{

    me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoFluent<?> fluent;
    Boolean validationEnabled;

    public LogInfoBuilder(){
            this(true);
    }
    public LogInfoBuilder(Boolean validationEnabled){
            this(new LogInfo(), validationEnabled);
    }
    public LogInfoBuilder(me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoFluent<?> fluent){
            this(fluent, true);
    }
    public LogInfoBuilder(me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LogInfo(), validationEnabled);
    }
    public LogInfoBuilder(me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoFluent<?> fluent,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo instance){
            this(fluent, instance, true);
    }
    public LogInfoBuilder(me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoFluent<?> fluent,me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttpMapping(instance.getHttpMapping()); 
            fluent.withLabelNames(instance.getLabelNames()); 
            fluent.withPayloadTemplate(instance.getPayloadTemplate()); 
            fluent.withSinkInfo(instance.getSinkInfo()); 
            this.validationEnabled = validationEnabled; 
    }
    public LogInfoBuilder(me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo instance){
            this(instance,true);
    }
    public LogInfoBuilder(me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttpMapping(instance.getHttpMapping()); 
            this.withLabelNames(instance.getLabelNames()); 
            this.withPayloadTemplate(instance.getPayloadTemplate()); 
            this.withSinkInfo(instance.getSinkInfo()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo build(){
            LogInfo buildable = new LogInfo(fluent.getHttpMapping(),fluent.getLabelNames(),fluent.getPayloadTemplate(),fluent.getSinkInfo());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LogInfoBuilder that = (LogInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
