package me.snowdrop.istio.mixer.adapter.stackdriver;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class LogInfoFluentImpl<A extends me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.adapter.stackdriver.LogInfoFluent<A>{

    private HttpRequestMappingBuilder httpMapping;
    private List<String> labelNames;
    private String payloadTemplate;
    private SinkInfoBuilder sinkInfo;

    public LogInfoFluentImpl(){
    }
    public LogInfoFluentImpl(me.snowdrop.istio.mixer.adapter.stackdriver.LogInfo instance){
            this.withHttpMapping(instance.getHttpMapping()); 
            this.withLabelNames(instance.getLabelNames()); 
            this.withPayloadTemplate(instance.getPayloadTemplate()); 
            this.withSinkInfo(instance.getSinkInfo()); 
    }

    
/**
 * This method has been deprecated, please use method buildHttpMapping instead.
 * @return The buildable object.
 */
@Deprecated public HttpRequestMapping getHttpMapping(){
            return this.httpMapping!=null?this.httpMapping.build():null;
    }

    public HttpRequestMapping buildHttpMapping(){
            return this.httpMapping!=null?this.httpMapping.build():null;
    }

    public A withHttpMapping(HttpRequestMapping httpMapping){
            _visitables.get("httpMapping").remove(this.httpMapping);
            if (httpMapping!=null){ this.httpMapping= new HttpRequestMappingBuilder(httpMapping); _visitables.get("httpMapping").add(this.httpMapping);} return (A) this;
    }

    public Boolean hasHttpMapping(){
            return this.httpMapping != null;
    }

    public LogInfoFluent.HttpMappingNested<A> withNewHttpMapping(){
            return new HttpMappingNestedImpl();
    }

    public LogInfoFluent.HttpMappingNested<A> withNewHttpMappingLike(HttpRequestMapping item){
            return new HttpMappingNestedImpl(item);
    }

    public LogInfoFluent.HttpMappingNested<A> editHttpMapping(){
            return withNewHttpMappingLike(getHttpMapping());
    }

    public LogInfoFluent.HttpMappingNested<A> editOrNewHttpMapping(){
            return withNewHttpMappingLike(getHttpMapping() != null ? getHttpMapping(): new HttpRequestMappingBuilder().build());
    }

    public LogInfoFluent.HttpMappingNested<A> editOrNewHttpMappingLike(HttpRequestMapping item){
            return withNewHttpMappingLike(getHttpMapping() != null ? getHttpMapping(): item);
    }

    public A addToLabelNames(int index,String item){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            this.labelNames.add(index, item);
            return (A)this;
    }

    public A setToLabelNames(int index,String item){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            this.labelNames.set(index, item); return (A)this;
    }

    public A addToLabelNames(String... items){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            for (String item : items) {this.labelNames.add(item);} return (A)this;
    }

    public A addAllToLabelNames(Collection<String> items){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            for (String item : items) {this.labelNames.add(item);} return (A)this;
    }

    public A removeFromLabelNames(String... items){
            for (String item : items) {if (this.labelNames!= null){ this.labelNames.remove(item);}} return (A)this;
    }

    public A removeAllFromLabelNames(Collection<String> items){
            for (String item : items) {if (this.labelNames!= null){ this.labelNames.remove(item);}} return (A)this;
    }

    public List<String> getLabelNames(){
            return this.labelNames;
    }

    public String getLabelName(int index){
            return this.labelNames.get(index);
    }

    public String getFirstLabelName(){
            return this.labelNames.get(0);
    }

    public String getLastLabelName(){
            return this.labelNames.get(labelNames.size() - 1);
    }

    public String getMatchingLabelName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: labelNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingLabelName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: labelNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withLabelNames(List<String> labelNames){
            if (this.labelNames != null) { _visitables.get("labelNames").removeAll(this.labelNames);}
            if (labelNames != null) {this.labelNames = new ArrayList<String>(); for (String item : labelNames){this.addToLabelNames(item);}} else { this.labelNames = null;} return (A) this;
    }

    public A withLabelNames(String... labelNames){
            if (this.labelNames != null) {this.labelNames.clear();}
            if (labelNames != null) {for (String item :labelNames){ this.addToLabelNames(item);}} return (A) this;
    }

    public Boolean hasLabelNames(){
            return labelNames != null && !labelNames.isEmpty();
    }

    public A addNewLabelName(String arg1){
            return (A)addToLabelNames(new String(arg1));
    }

    public A addNewLabelName(StringBuilder arg1){
            return (A)addToLabelNames(new String(arg1));
    }

    public A addNewLabelName(StringBuffer arg1){
            return (A)addToLabelNames(new String(arg1));
    }

    public String getPayloadTemplate(){
            return this.payloadTemplate;
    }

    public A withPayloadTemplate(String payloadTemplate){
            this.payloadTemplate=payloadTemplate; return (A) this;
    }

    public Boolean hasPayloadTemplate(){
            return this.payloadTemplate != null;
    }

    public A withNewPayloadTemplate(String arg1){
            return (A)withPayloadTemplate(new String(arg1));
    }

    public A withNewPayloadTemplate(StringBuilder arg1){
            return (A)withPayloadTemplate(new String(arg1));
    }

    public A withNewPayloadTemplate(StringBuffer arg1){
            return (A)withPayloadTemplate(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSinkInfo instead.
 * @return The buildable object.
 */
@Deprecated public SinkInfo getSinkInfo(){
            return this.sinkInfo!=null?this.sinkInfo.build():null;
    }

    public SinkInfo buildSinkInfo(){
            return this.sinkInfo!=null?this.sinkInfo.build():null;
    }

    public A withSinkInfo(SinkInfo sinkInfo){
            _visitables.get("sinkInfo").remove(this.sinkInfo);
            if (sinkInfo!=null){ this.sinkInfo= new SinkInfoBuilder(sinkInfo); _visitables.get("sinkInfo").add(this.sinkInfo);} return (A) this;
    }

    public Boolean hasSinkInfo(){
            return this.sinkInfo != null;
    }

    public LogInfoFluent.SinkInfoNested<A> withNewSinkInfo(){
            return new SinkInfoNestedImpl();
    }

    public LogInfoFluent.SinkInfoNested<A> withNewSinkInfoLike(SinkInfo item){
            return new SinkInfoNestedImpl(item);
    }

    public LogInfoFluent.SinkInfoNested<A> editSinkInfo(){
            return withNewSinkInfoLike(getSinkInfo());
    }

    public LogInfoFluent.SinkInfoNested<A> editOrNewSinkInfo(){
            return withNewSinkInfoLike(getSinkInfo() != null ? getSinkInfo(): new SinkInfoBuilder().build());
    }

    public LogInfoFluent.SinkInfoNested<A> editOrNewSinkInfoLike(SinkInfo item){
            return withNewSinkInfoLike(getSinkInfo() != null ? getSinkInfo(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LogInfoFluentImpl that = (LogInfoFluentImpl) o;
            if (httpMapping != null ? !httpMapping.equals(that.httpMapping) :that.httpMapping != null) return false;
            if (labelNames != null ? !labelNames.equals(that.labelNames) :that.labelNames != null) return false;
            if (payloadTemplate != null ? !payloadTemplate.equals(that.payloadTemplate) :that.payloadTemplate != null) return false;
            if (sinkInfo != null ? !sinkInfo.equals(that.sinkInfo) :that.sinkInfo != null) return false;
            return true;
    }


    public class HttpMappingNestedImpl<N> extends HttpRequestMappingFluentImpl<LogInfoFluent.HttpMappingNested<N>> implements LogInfoFluent.HttpMappingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HttpRequestMappingBuilder builder;
    
            HttpMappingNestedImpl(HttpRequestMapping item){
                    this.builder = new HttpRequestMappingBuilder(this, item);
            }
            HttpMappingNestedImpl(){
                    this.builder = new HttpRequestMappingBuilder(this);
            }
    
    public N and(){
            return (N) LogInfoFluentImpl.this.withHttpMapping(builder.build());
    }
    public N endHttpMapping(){
            return and();
    }

}
    public class SinkInfoNestedImpl<N> extends SinkInfoFluentImpl<LogInfoFluent.SinkInfoNested<N>> implements LogInfoFluent.SinkInfoNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SinkInfoBuilder builder;
    
            SinkInfoNestedImpl(SinkInfo item){
                    this.builder = new SinkInfoBuilder(this, item);
            }
            SinkInfoNestedImpl(){
                    this.builder = new SinkInfoBuilder(this);
            }
    
    public N and(){
            return (N) LogInfoFluentImpl.this.withSinkInfo(builder.build());
    }
    public N endSinkInfo(){
            return and();
    }

}


}
