package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceAccountPathCredsBuilder extends ServiceAccountPathCredsFluentImpl<ServiceAccountPathCredsBuilder> implements VisitableBuilder<ServiceAccountPathCreds,ServiceAccountPathCredsBuilder>{

    ServiceAccountPathCredsFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceAccountPathCredsBuilder(){
            this(true);
    }
    public ServiceAccountPathCredsBuilder(Boolean validationEnabled){
            this(new ServiceAccountPathCreds(), validationEnabled);
    }
    public ServiceAccountPathCredsBuilder(ServiceAccountPathCredsFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceAccountPathCredsBuilder(ServiceAccountPathCredsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceAccountPathCreds(), validationEnabled);
    }
    public ServiceAccountPathCredsBuilder(ServiceAccountPathCredsFluent<?> fluent,ServiceAccountPathCreds instance){
            this(fluent, instance, true);
    }
    public ServiceAccountPathCredsBuilder(ServiceAccountPathCredsFluent<?> fluent,ServiceAccountPathCreds instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withServiceAccountPath(instance.getServiceAccountPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceAccountPathCredsBuilder(ServiceAccountPathCreds instance){
            this(instance,true);
    }
    public ServiceAccountPathCredsBuilder(ServiceAccountPathCreds instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withServiceAccountPath(instance.getServiceAccountPath()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceAccountPathCreds build(){
            ServiceAccountPathCreds buildable = new ServiceAccountPathCreds(fluent.getServiceAccountPath());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceAccountPathCredsBuilder that = (ServiceAccountPathCredsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
