package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SinkInfoBuilder extends SinkInfoFluentImpl<SinkInfoBuilder> implements VisitableBuilder<SinkInfo,SinkInfoBuilder>{

    SinkInfoFluent<?> fluent;
    Boolean validationEnabled;

    public SinkInfoBuilder(){
            this(true);
    }
    public SinkInfoBuilder(Boolean validationEnabled){
            this(new SinkInfo(), validationEnabled);
    }
    public SinkInfoBuilder(SinkInfoFluent<?> fluent){
            this(fluent, true);
    }
    public SinkInfoBuilder(SinkInfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SinkInfo(), validationEnabled);
    }
    public SinkInfoBuilder(SinkInfoFluent<?> fluent,SinkInfo instance){
            this(fluent, instance, true);
    }
    public SinkInfoBuilder(SinkInfoFluent<?> fluent,SinkInfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUniqueWriterIdentity(instance.getUniqueWriterIdentity()); 
            fluent.withUpdateDestination(instance.getUpdateDestination()); 
            fluent.withUpdateFilter(instance.getUpdateFilter()); 
            fluent.withUpdateIncludeChildren(instance.getUpdateIncludeChildren()); 
            fluent.withDestination(instance.getDestination()); 
            fluent.withFilter(instance.getFilter()); 
            fluent.withId(instance.getId()); 
            this.validationEnabled = validationEnabled; 
    }
    public SinkInfoBuilder(SinkInfo instance){
            this(instance,true);
    }
    public SinkInfoBuilder(SinkInfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUniqueWriterIdentity(instance.getUniqueWriterIdentity()); 
            this.withUpdateDestination(instance.getUpdateDestination()); 
            this.withUpdateFilter(instance.getUpdateFilter()); 
            this.withUpdateIncludeChildren(instance.getUpdateIncludeChildren()); 
            this.withDestination(instance.getDestination()); 
            this.withFilter(instance.getFilter()); 
            this.withId(instance.getId()); 
            this.validationEnabled = validationEnabled; 
    }

    public SinkInfo build(){
            SinkInfo buildable = new SinkInfo(fluent.isUniqueWriterIdentity(),fluent.isUpdateDestination(),fluent.isUpdateFilter(),fluent.isUpdateIncludeChildren(),fluent.getDestination(),fluent.getFilter(),fluent.getId());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SinkInfoBuilder that = (SinkInfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
