package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;

public interface StackdriverFluent<A extends StackdriverFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public StackdriverFluent.MetadataNested<A> withNewMetadata();
    public StackdriverFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public StackdriverFluent.MetadataNested<A> editMetadata();
    public StackdriverFluent.MetadataNested<A> editOrNewMetadata();
    public StackdriverFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public StackdriverSpec getSpec();
    public StackdriverSpec buildSpec();
    public A withSpec(StackdriverSpec spec);
    public Boolean hasSpec();
    public StackdriverFluent.SpecNested<A> withNewSpec();
    public StackdriverFluent.SpecNested<A> withNewSpecLike(StackdriverSpec item);
    public StackdriverFluent.SpecNested<A> editSpec();
    public StackdriverFluent.SpecNested<A> editOrNewSpec();
    public StackdriverFluent.SpecNested<A> editOrNewSpecLike(StackdriverSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<StackdriverFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,StackdriverSpecFluent<StackdriverFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
