package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface StackdriverListFluent<A extends StackdriverListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Stackdriver item);
    public A setToItems(int index,Stackdriver item);
    public A addToItems(Stackdriver... items);
    public A addAllToItems(Collection<Stackdriver> items);
    public A removeFromItems(Stackdriver... items);
    public A removeAllFromItems(Collection<Stackdriver> items);
    public A removeMatchingFromItems(Predicate<StackdriverBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Stackdriver> getItems();
    public List<Stackdriver> buildItems();
    public Stackdriver buildItem(int index);
    public Stackdriver buildFirstItem();
    public Stackdriver buildLastItem();
    public Stackdriver buildMatchingItem(Predicate<StackdriverBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<StackdriverBuilder> predicate);
    public A withItems(List<Stackdriver> items);
    public A withItems(Stackdriver... items);
    public Boolean hasItems();
    public StackdriverListFluent.ItemsNested<A> addNewItem();
    public StackdriverListFluent.ItemsNested<A> addNewItemLike(Stackdriver item);
    public StackdriverListFluent.ItemsNested<A> setNewItemLike(int index,Stackdriver item);
    public StackdriverListFluent.ItemsNested<A> editItem(int index);
    public StackdriverListFluent.ItemsNested<A> editFirstItem();
    public StackdriverListFluent.ItemsNested<A> editLastItem();
    public StackdriverListFluent.ItemsNested<A> editMatchingItem(Predicate<StackdriverBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,StackdriverFluent<StackdriverListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
