package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StackdriverSpecBuilder extends StackdriverSpecFluentImpl<StackdriverSpecBuilder> implements VisitableBuilder<StackdriverSpec,StackdriverSpecBuilder>{

    StackdriverSpecFluent<?> fluent;
    Boolean validationEnabled;

    public StackdriverSpecBuilder(){
            this(true);
    }
    public StackdriverSpecBuilder(Boolean validationEnabled){
            this(new StackdriverSpec(), validationEnabled);
    }
    public StackdriverSpecBuilder(StackdriverSpecFluent<?> fluent){
            this(fluent, true);
    }
    public StackdriverSpecBuilder(StackdriverSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StackdriverSpec(), validationEnabled);
    }
    public StackdriverSpecBuilder(StackdriverSpecFluent<?> fluent,StackdriverSpec instance){
            this(fluent, instance, true);
    }
    public StackdriverSpecBuilder(StackdriverSpecFluent<?> fluent,StackdriverSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCreds(instance.getCreds()); 
            fluent.withEndpoint(instance.getEndpoint()); 
            fluent.withLogInfo(instance.getLogInfo()); 
            fluent.withMetricInfo(instance.getMetricInfo()); 
            fluent.withProjectId(instance.getProjectId()); 
            fluent.withPushInterval(instance.getPushInterval()); 
            fluent.withTrace(instance.getTrace()); 
            this.validationEnabled = validationEnabled; 
    }
    public StackdriverSpecBuilder(StackdriverSpec instance){
            this(instance,true);
    }
    public StackdriverSpecBuilder(StackdriverSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCreds(instance.getCreds()); 
            this.withEndpoint(instance.getEndpoint()); 
            this.withLogInfo(instance.getLogInfo()); 
            this.withMetricInfo(instance.getMetricInfo()); 
            this.withProjectId(instance.getProjectId()); 
            this.withPushInterval(instance.getPushInterval()); 
            this.withTrace(instance.getTrace()); 
            this.validationEnabled = validationEnabled; 
    }

    public StackdriverSpec build(){
            StackdriverSpec buildable = new StackdriverSpec(fluent.getCreds(),fluent.getEndpoint(),fluent.getLogInfo(),fluent.getMetricInfo(),fluent.getProjectId(),fluent.getPushInterval(),fluent.getTrace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StackdriverSpecBuilder that = (StackdriverSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
