package me.snowdrop.istio.mixer.adapter.statsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StatsdBuilder extends StatsdFluentImpl<StatsdBuilder> implements VisitableBuilder<Statsd,StatsdBuilder>{

    StatsdFluent<?> fluent;
    Boolean validationEnabled;

    public StatsdBuilder(){
            this(true);
    }
    public StatsdBuilder(Boolean validationEnabled){
            this(new Statsd(), validationEnabled);
    }
    public StatsdBuilder(StatsdFluent<?> fluent){
            this(fluent, true);
    }
    public StatsdBuilder(StatsdFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Statsd(), validationEnabled);
    }
    public StatsdBuilder(StatsdFluent<?> fluent,Statsd instance){
            this(fluent, instance, true);
    }
    public StatsdBuilder(StatsdFluent<?> fluent,Statsd instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatsdBuilder(Statsd instance){
            this(instance,true);
    }
    public StatsdBuilder(Statsd instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Statsd build(){
            Statsd buildable = new Statsd(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatsdBuilder that = (StatsdBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
