package me.snowdrop.istio.mixer.adapter.statsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface StatsdListFluent<A extends StatsdListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Statsd item);
    public A setToItems(int index,Statsd item);
    public A addToItems(Statsd... items);
    public A addAllToItems(Collection<Statsd> items);
    public A removeFromItems(Statsd... items);
    public A removeAllFromItems(Collection<Statsd> items);
    public A removeMatchingFromItems(Predicate<StatsdBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Statsd> getItems();
    public List<Statsd> buildItems();
    public Statsd buildItem(int index);
    public Statsd buildFirstItem();
    public Statsd buildLastItem();
    public Statsd buildMatchingItem(Predicate<StatsdBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<StatsdBuilder> predicate);
    public A withItems(List<Statsd> items);
    public A withItems(Statsd... items);
    public Boolean hasItems();
    public StatsdListFluent.ItemsNested<A> addNewItem();
    public StatsdListFluent.ItemsNested<A> addNewItemLike(Statsd item);
    public StatsdListFluent.ItemsNested<A> setNewItemLike(int index,Statsd item);
    public StatsdListFluent.ItemsNested<A> editItem(int index);
    public StatsdListFluent.ItemsNested<A> editFirstItem();
    public StatsdListFluent.ItemsNested<A> editLastItem();
    public StatsdListFluent.ItemsNested<A> editMatchingItem(Predicate<StatsdBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,StatsdFluent<StatsdListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
