package me.snowdrop.istio.mixer.adapter.stdio;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface StdioFluent<A extends StdioFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public StdioFluent.MetadataNested<A> withNewMetadata();
    public StdioFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public StdioFluent.MetadataNested<A> editMetadata();
    public StdioFluent.MetadataNested<A> editOrNewMetadata();
    public StdioFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public StdioSpec getSpec();
    public StdioSpec buildSpec();
    public A withSpec(StdioSpec spec);
    public Boolean hasSpec();
    public StdioFluent.SpecNested<A> withNewSpec();
    public StdioFluent.SpecNested<A> withNewSpecLike(StdioSpec item);
    public StdioFluent.SpecNested<A> editSpec();
    public StdioFluent.SpecNested<A> editOrNewSpec();
    public StdioFluent.SpecNested<A> editOrNewSpecLike(StdioSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<StdioFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,StdioSpecFluent<StdioFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
