package me.snowdrop.istio.mixer.adapter.stdio;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class StdioSpecFluentImpl<A extends StdioSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StdioSpecFluent<A>{

    private me.snowdrop.istio.mixer.adapter.stdio.Stream logStream;
    private Integer maxDaysBeforeRotation;
    private Integer maxMegabytesBeforeRotation;
    private Integer maxRotatedFiles;
    private Level metricLevel;
    private Boolean outputAsJson;
    private Level outputLevel;
    private String outputPath;
    private Map<String,Integer> severityLevels;

    public StdioSpecFluentImpl(){
    }
    public StdioSpecFluentImpl(StdioSpec instance){
            this.withLogStream(instance.getLogStream()); 
            this.withMaxDaysBeforeRotation(instance.getMaxDaysBeforeRotation()); 
            this.withMaxMegabytesBeforeRotation(instance.getMaxMegabytesBeforeRotation()); 
            this.withMaxRotatedFiles(instance.getMaxRotatedFiles()); 
            this.withMetricLevel(instance.getMetricLevel()); 
            this.withOutputAsJson(instance.getOutputAsJson()); 
            this.withOutputLevel(instance.getOutputLevel()); 
            this.withOutputPath(instance.getOutputPath()); 
            this.withSeverityLevels(instance.getSeverityLevels()); 
    }

    public me.snowdrop.istio.mixer.adapter.stdio.Stream getLogStream(){
            return this.logStream;
    }

    public A withLogStream(me.snowdrop.istio.mixer.adapter.stdio.Stream logStream){
            this.logStream=logStream; return (A) this;
    }

    public Boolean hasLogStream(){
            return this.logStream != null;
    }

    public Integer getMaxDaysBeforeRotation(){
            return this.maxDaysBeforeRotation;
    }

    public A withMaxDaysBeforeRotation(Integer maxDaysBeforeRotation){
            this.maxDaysBeforeRotation=maxDaysBeforeRotation; return (A) this;
    }

    public Boolean hasMaxDaysBeforeRotation(){
            return this.maxDaysBeforeRotation != null;
    }

    public Integer getMaxMegabytesBeforeRotation(){
            return this.maxMegabytesBeforeRotation;
    }

    public A withMaxMegabytesBeforeRotation(Integer maxMegabytesBeforeRotation){
            this.maxMegabytesBeforeRotation=maxMegabytesBeforeRotation; return (A) this;
    }

    public Boolean hasMaxMegabytesBeforeRotation(){
            return this.maxMegabytesBeforeRotation != null;
    }

    public Integer getMaxRotatedFiles(){
            return this.maxRotatedFiles;
    }

    public A withMaxRotatedFiles(Integer maxRotatedFiles){
            this.maxRotatedFiles=maxRotatedFiles; return (A) this;
    }

    public Boolean hasMaxRotatedFiles(){
            return this.maxRotatedFiles != null;
    }

    public Level getMetricLevel(){
            return this.metricLevel;
    }

    public A withMetricLevel(Level metricLevel){
            this.metricLevel=metricLevel; return (A) this;
    }

    public Boolean hasMetricLevel(){
            return this.metricLevel != null;
    }

    public Boolean isOutputAsJson(){
            return this.outputAsJson;
    }

    public A withOutputAsJson(Boolean outputAsJson){
            this.outputAsJson=outputAsJson; return (A) this;
    }

    public Boolean hasOutputAsJson(){
            return this.outputAsJson != null;
    }

    public A withNewOutputAsJson(String arg1){
            return (A)withOutputAsJson(new Boolean(arg1));
    }

    public A withNewOutputAsJson(boolean arg1){
            return (A)withOutputAsJson(new Boolean(arg1));
    }

    public Level getOutputLevel(){
            return this.outputLevel;
    }

    public A withOutputLevel(Level outputLevel){
            this.outputLevel=outputLevel; return (A) this;
    }

    public Boolean hasOutputLevel(){
            return this.outputLevel != null;
    }

    public String getOutputPath(){
            return this.outputPath;
    }

    public A withOutputPath(String outputPath){
            this.outputPath=outputPath; return (A) this;
    }

    public Boolean hasOutputPath(){
            return this.outputPath != null;
    }

    public A withNewOutputPath(String arg1){
            return (A)withOutputPath(new String(arg1));
    }

    public A withNewOutputPath(StringBuilder arg1){
            return (A)withOutputPath(new String(arg1));
    }

    public A withNewOutputPath(StringBuffer arg1){
            return (A)withOutputPath(new String(arg1));
    }

    public A addToSeverityLevels(String key,Integer value){
            if(this.severityLevels == null && key != null && value != null) { this.severityLevels = new LinkedHashMap<String,Integer>(); }
            if(key != null && value != null) {this.severityLevels.put(key, value);} return (A)this;
    }

    public A addToSeverityLevels(Map<String,Integer> map){
            if(this.severityLevels == null && map != null) { this.severityLevels = new LinkedHashMap<String,Integer>(); }
            if(map != null) { this.severityLevels.putAll(map);} return (A)this;
    }

    public A removeFromSeverityLevels(String key){
            if(this.severityLevels == null) { return (A) this; }
            if(key != null && this.severityLevels != null) {this.severityLevels.remove(key);} return (A)this;
    }

    public A removeFromSeverityLevels(Map<String,Integer> map){
            if(this.severityLevels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.severityLevels != null){this.severityLevels.remove(key);}}} return (A)this;
    }

    public Map<String,Integer> getSeverityLevels(){
            return this.severityLevels;
    }

    public A withSeverityLevels(Map<String,Integer> severityLevels){
            if (severityLevels == null) { this.severityLevels =  null;} else {this.severityLevels = new LinkedHashMap<String,Integer>(severityLevels);} return (A) this;
    }

    public Boolean hasSeverityLevels(){
            return this.severityLevels != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StdioSpecFluentImpl that = (StdioSpecFluentImpl) o;
            if (logStream != null ? !logStream.equals(that.logStream) :that.logStream != null) return false;
            if (maxDaysBeforeRotation != null ? !maxDaysBeforeRotation.equals(that.maxDaysBeforeRotation) :that.maxDaysBeforeRotation != null) return false;
            if (maxMegabytesBeforeRotation != null ? !maxMegabytesBeforeRotation.equals(that.maxMegabytesBeforeRotation) :that.maxMegabytesBeforeRotation != null) return false;
            if (maxRotatedFiles != null ? !maxRotatedFiles.equals(that.maxRotatedFiles) :that.maxRotatedFiles != null) return false;
            if (metricLevel != null ? !metricLevel.equals(that.metricLevel) :that.metricLevel != null) return false;
            if (outputAsJson != null ? !outputAsJson.equals(that.outputAsJson) :that.outputAsJson != null) return false;
            if (outputLevel != null ? !outputLevel.equals(that.outputLevel) :that.outputLevel != null) return false;
            if (outputPath != null ? !outputPath.equals(that.outputPath) :that.outputPath != null) return false;
            if (severityLevels != null ? !severityLevels.equals(that.severityLevels) :that.severityLevels != null) return false;
            return true;
    }




}
