package me.snowdrop.istio.mixer.adapter.zipkin;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ZipkinBuilder extends ZipkinFluentImpl<ZipkinBuilder> implements VisitableBuilder<Zipkin,ZipkinBuilder>{

    ZipkinFluent<?> fluent;
    Boolean validationEnabled;

    public ZipkinBuilder(){
            this(true);
    }
    public ZipkinBuilder(Boolean validationEnabled){
            this(new Zipkin(), validationEnabled);
    }
    public ZipkinBuilder(ZipkinFluent<?> fluent){
            this(fluent, true);
    }
    public ZipkinBuilder(ZipkinFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Zipkin(), validationEnabled);
    }
    public ZipkinBuilder(ZipkinFluent<?> fluent,Zipkin instance){
            this(fluent, instance, true);
    }
    public ZipkinBuilder(ZipkinFluent<?> fluent,Zipkin instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ZipkinBuilder(Zipkin instance){
            this(instance,true);
    }
    public ZipkinBuilder(Zipkin instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Zipkin build(){
            Zipkin buildable = new Zipkin(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ZipkinBuilder that = (ZipkinBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
