package me.snowdrop.istio.mixer.adapter.zipkin;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Double;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface ZipkinFluent<A extends ZipkinFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ZipkinFluent.MetadataNested<A> withNewMetadata();
    public ZipkinFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ZipkinFluent.MetadataNested<A> editMetadata();
    public ZipkinFluent.MetadataNested<A> editOrNewMetadata();
    public ZipkinFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ZipkinSpec getSpec();
    public ZipkinSpec buildSpec();
    public A withSpec(ZipkinSpec spec);
    public Boolean hasSpec();
    public A withNewSpec(Double sampleProbability,String url);
    public ZipkinFluent.SpecNested<A> withNewSpec();
    public ZipkinFluent.SpecNested<A> withNewSpecLike(ZipkinSpec item);
    public ZipkinFluent.SpecNested<A> editSpec();
    public ZipkinFluent.SpecNested<A> editOrNewSpec();
    public ZipkinFluent.SpecNested<A> editOrNewSpecLike(ZipkinSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ZipkinFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ZipkinSpecFluent<ZipkinFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
