package me.snowdrop.istio.mixer.adapter.zipkin;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ZipkinListBuilder extends ZipkinListFluentImpl<ZipkinListBuilder> implements VisitableBuilder<ZipkinList,ZipkinListBuilder>{

    ZipkinListFluent<?> fluent;
    Boolean validationEnabled;

    public ZipkinListBuilder(){
            this(true);
    }
    public ZipkinListBuilder(Boolean validationEnabled){
            this(new ZipkinList(), validationEnabled);
    }
    public ZipkinListBuilder(ZipkinListFluent<?> fluent){
            this(fluent, true);
    }
    public ZipkinListBuilder(ZipkinListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ZipkinList(), validationEnabled);
    }
    public ZipkinListBuilder(ZipkinListFluent<?> fluent,ZipkinList instance){
            this(fluent, instance, true);
    }
    public ZipkinListBuilder(ZipkinListFluent<?> fluent,ZipkinList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ZipkinListBuilder(ZipkinList instance){
            this(instance,true);
    }
    public ZipkinListBuilder(ZipkinList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ZipkinList build(){
            ZipkinList buildable = new ZipkinList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ZipkinListBuilder that = (ZipkinListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
