package me.snowdrop.istio.mixer.adapter.zipkin;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ZipkinListFluent<A extends ZipkinListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Zipkin item);
    public A setToItems(int index,Zipkin item);
    public A addToItems(Zipkin... items);
    public A addAllToItems(Collection<Zipkin> items);
    public A removeFromItems(Zipkin... items);
    public A removeAllFromItems(Collection<Zipkin> items);
    public A removeMatchingFromItems(Predicate<ZipkinBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Zipkin> getItems();
    public List<Zipkin> buildItems();
    public Zipkin buildItem(int index);
    public Zipkin buildFirstItem();
    public Zipkin buildLastItem();
    public Zipkin buildMatchingItem(Predicate<ZipkinBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ZipkinBuilder> predicate);
    public A withItems(List<Zipkin> items);
    public A withItems(Zipkin... items);
    public Boolean hasItems();
    public ZipkinListFluent.ItemsNested<A> addNewItem();
    public ZipkinListFluent.ItemsNested<A> addNewItemLike(Zipkin item);
    public ZipkinListFluent.ItemsNested<A> setNewItemLike(int index,Zipkin item);
    public ZipkinListFluent.ItemsNested<A> editItem(int index);
    public ZipkinListFluent.ItemsNested<A> editFirstItem();
    public ZipkinListFluent.ItemsNested<A> editLastItem();
    public ZipkinListFluent.ItemsNested<A> editMatchingItem(Predicate<ZipkinBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ZipkinFluent<ZipkinListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
